//@author: antokhio
//@help: template
//@tags: template
//@credits: vvvv
#include "..\common\PE_Vertex.fxh"

float4x4 tVP;

float4x4 tW : WORLD;

bool TagAdd;
bool TagRemove;
//bool TagInvert;

bool SelectAll<bool bang = true;>;
bool DeselectAll <bool bang = true;>;

RWStructuredBuffer<Vertex> Output : BACKBUFFER;

bool InRect (float2 x, float2 c, float2 s)
{
	if (abs(c.x - x.x) < s.x/2 && abs(c.y - x.y) < s.y/2 )
	return true;
	else
	return false;
}

bool HitTestTransform (float4 p, float4x4 t)
{
	p = mul(p,t);
	p.xzy /= p.w;
	p.xyz = abs (p.xyz); 	
	//return (!(p.x > 0.5f ||  p.y > 0.5f || p.z > 0.5f));
	if (p.x > 0.5f ||  p.y > 0.5f || p.z > 0.5f)
		return false;
	else 
		return true;
};

void HitTestAdd (uint id)
{
	float4 p = mul (float4 (Output[id].pos,1), tW);
	p.xyz /= p.w;
	p.xyz = abs(p.xyz);
	if (!(p.x > 0.5f ||  p.y > 0.5f || p.z > 0.5f))
		Output[id].tag = true;
}
void HitTestRemove (uint id)
{
	float4 p = mul (float4 (Output[id].pos,1), tW);
	p.xyz /= p.w;
	p.xyz = abs(p.xyz);
	if (!(p.x > 0.5f ||  p.y > 0.5f || p.z > 0.5f))
		Output[id].tag = false;
}

[numthreads(32, 1, 1)]
void CS_CREATEBUFFER( uint3 DTid : SV_DispatchThreadID )
{
	if (TagAdd && Output[DTid.x].tag != 1)
	{
		HitTestAdd(DTid.x); 
	}
	if (TagRemove )
	{
		HitTestRemove(DTid.x);
	}

	if (SelectAll)
		Output[DTid.x].tag = 1;
	if (DeselectAll)
		Output[DTid.x].tag = 0;
	
}
technique11 PE_TegSelectClear
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS_CREATEBUFFER() ) );
	}
}
